/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import org.spigotmc.ActivationRange;
import org.spigotmc.SpigotWorldConfig;

public class TrackingRange {
    public static int getEntityTrackingRange(Entity entity, int defaultRange) {
        if (defaultRange == 0) {
            return defaultRange;
        }
        SpigotWorldConfig config = entity.f_19853_.spigotConfig;
        if (entity instanceof Player) {
            return config.playerTrackingRange;
        }
        if (entity.activationType == ActivationRange.ActivationType.MONSTER || entity.activationType == ActivationRange.ActivationType.RAIDER) {
            return config.monsterTrackingRange;
        }
        if (entity instanceof Ghast) {
            if (config.monsterTrackingRange > config.monsterActivationRange) {
                return config.monsterTrackingRange;
            }
            return config.monsterActivationRange;
        }
        if (entity.activationType == ActivationRange.ActivationType.ANIMAL) {
            return config.animalTrackingRange;
        }
        if (entity instanceof ItemFrame || entity instanceof Painting || entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return config.miscTrackingRange;
        }
        return config.otherTrackingRange;
    }
}

